//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.ui.theme](../index.md)/[Colors](index.md)

# Colors

@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)

class [Colors](index.md)(isDark: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), primary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onPrimary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), header: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onHeader: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), background: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onBackground: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), surface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSurface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSurfaceVariant: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), border: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), message: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onMessage: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), chatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onChatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), caption: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), success: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSuccess: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), error: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onError: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), ripple: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), scrim: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html))

ColorScheme that drives all BotStacks Components.

#### Parameters

common

| | |
|---|---|
| isDark | if this scheme is for Dark mode. |
| primary | The primary color is the color displayed most frequently across your app’s screens and components. |
| onPrimary | Color used for text and icons displayed on top of the primary color. |
| header | The preferred background color for the [ai.botstacks.sdk.ui.components.Header](../../ai.botstacks.sdk.ui.components/-header.md) component. |
| onHeader | Color used for text and icons displayed on top of the header color. |
| background | The background color that appears behind scrollable content. |
| onBackground | Color used for text and icons displayed on top of the background color. |
| surface | The surface color that affect surfaces of components, such as cards, sheets, and menus. |
| onSurface | Color used for text and icons displayed on top of the surface color. |
| onSurfaceVariant | The color (and state variants) that can be used for content on top of surface. |
| border | Subtle color used for boundaries. Outline color role adds contrast for accessibility purposes. |
| message | The color used for rendering incoming Chat Messages [ai.botstacks.sdk.ui.components.ChatMessage](../../ai.botstacks.sdk.ui.components/-chat-message.md) (not from current user). |
| chatInput | The color that affects the background of the [ai.botstacks.sdk.ui.components.ChatInput](../../ai.botstacks.sdk.ui.components/-chat-input.md) component. |
| onChatInput | Color used for text and icons displayed on top of the chatInput color. |
| caption | Color used for text and icons that are supplementary in nature (e.g timestamps in chat). |
| success | Color used to represent a success state, as well as online statuses when present. |
| error | The error color is used to indicate errors in components, as well as the offline statuses when present. |
| onError | Color used for text and icons displayed on top of the error color. |
| ripple | Color used for click interactions that &quot;ripple&quot; behind content. |
| scrim | Color of a scrim that obscures content. |

## Constructors

| | |
|---|---|
| [Colors](-colors.md) | [common]<br>constructor(isDark: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), primary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onPrimary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), header: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onHeader: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), background: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onBackground: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), surface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSurface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSurfaceVariant: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), border: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), message: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onMessage: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), chatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onChatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), caption: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), success: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSuccess: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), error: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onError: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), ripple: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), scrim: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html)) |

## Properties

| Name | Summary |
|---|---|
| [background](background.md) | [common]<br>var [background](background.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [border](border.md) | [common]<br>var [border](border.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [caption](caption.md) | [common]<br>var [caption](caption.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [chatInput](chat-input.md) | [common]<br>var [chatInput](chat-input.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [error](error.md) | [common]<br>var [error](error.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [header](header.md) | [common]<br>var [header](header.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [isDark](is-dark.md) | [common]<br>var [isDark](is-dark.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [message](message.md) | [common]<br>var [message](message.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onBackground](on-background.md) | [common]<br>var [onBackground](on-background.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onChatInput](on-chat-input.md) | [common]<br>var [onChatInput](on-chat-input.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onError](on-error.md) | [common]<br>var [onError](on-error.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onHeader](on-header.md) | [common]<br>var [onHeader](on-header.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onMessage](on-message.md) | [common]<br>var [onMessage](on-message.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onPrimary](on-primary.md) | [common]<br>var [onPrimary](on-primary.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onSuccess](on-success.md) | [common]<br>var [onSuccess](on-success.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onSurface](on-surface.md) | [common]<br>var [onSurface](on-surface.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [onSurfaceVariant](on-surface-variant.md) | [common]<br>var [onSurfaceVariant](on-surface-variant.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [primary](primary.md) | [common]<br>var [primary](primary.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [ripple](ripple.md) | [common]<br>var [ripple](ripple.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [scrim](scrim.md) | [common]<br>var [scrim](scrim.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [success](success.md) | [common]<br>var [success](success.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |
| [surface](surface.md) | [common]<br>var [surface](surface.md): [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) |

## Functions

| Name | Summary |
|---|---|
| [asMaterialColorScheme](as-material-color-scheme.md) | [common]<br>fun [asMaterialColorScheme](as-material-color-scheme.md)(): [ColorScheme](https://developer.android.com/reference/kotlin/androidx/compose/material3/ColorScheme.html) |
| [copy](copy.md) | [common]<br>fun [copy](copy.md)(primary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.primary, onPrimary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onPrimary, header: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.header, onHeader: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onHeader, background: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.background, onBackground: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onBackground, surface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.surface, onSurface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onSurface, onSurfaceVariant: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onSurfaceVariant, border: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.border, message: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.message, onMessage: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onMessage, chatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.chatInput, onChatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onChatInput, caption: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.caption, success: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.success, onSuccess: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onSuccess, error: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.error, onError: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.onError, ripple: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.ripple, scrim: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = this.scrim): [Colors](index.md)<br>Returns a copy of this ColorScheme, optionally overriding some of the values. |
